<?php

if (!defined('ABSPATH')) {
	exit;
}

if (!class_exists('Header_Builder_View_Language')) {

	class Header_Builder_View_Language {
		
		var $header_css;

		function __construct($css_class) {
			$this->header_css = $css_class;

			add_filter('header_builder_view_language', array($this, 'render'));
		}

		public function render($args = array()) {
			extract(
				shortcode_atts(
					array(
						'uniqid' => uniqid('language-switcher-'),
						'font_size' => '',
						'with_background' => 'yes',
						'background_color' => '',
						'color' => '',
						'color_on_hover' => '',
					),
					$args
				)
			);

			yprm_buildCSS(".$this->header_css .$uniqid" , array(
				'font-size' => $font_size,
				'background_color' => $with_background == 'yes' ? $background_color : '',
				'color' => $color
			));

			yprm_buildCSS(".$this->header_css .$uniqid svg" , array(
				'color' => $color
			));

			yprm_buildCSS(".$this->header_css .$uniqid a:hover" , array(
				'color' => $color_on_hover
			));

			if($with_background != 'yes') {
				$uniqid .= ' without-bg';
			}

			$languages_array = array();

			if(function_exists('pll_the_languages') && $array = pll_the_languages(array('raw'=>1))) {
				$languages_array = $array;
			} else if(function_exists('icl_get_languages') && $array = icl_get_languages('skip_missing=0')) {
				if(is_array($array) && count($array) > 0) {
					foreach($array as $item) {
						$languages_array[] = array(
							'current_lang' => $item['active'],
							'url' => $item['url'],
							'slug' => $item['code']
						);
					}
				}
				
			}

			if(count($languages_array) == 0) return false;

			?>
			<div class="language-switcher <?php echo esc_attr($uniqid) ?>">
				<svg width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M20.8438 11.5C20.8438 6.33982 16.6602 2.15625 11.5 2.15625C6.33982 2.15625 2.15625 6.33982 2.15625 11.5C2.15625 16.6602 6.33982 20.8438 11.5 20.8438C16.6602 20.8438 20.8438 16.6602 20.8438 11.5Z" stroke="currentColor" stroke-width="1.4375" stroke-miterlimit="10"/>
					<path d="M20.0159 7.73284C19.2944 7.73733 19.3654 9.06837 18.4665 8.44036C18.1328 8.20767 17.9275 7.8694 17.5083 7.76653C17.1422 7.67669 16.7671 7.77013 16.4055 7.83257C15.9945 7.90355 15.5071 7.93544 15.1953 8.24675C14.8939 8.54638 14.7344 8.94843 14.4137 9.24985C13.7933 9.83384 13.5314 10.4713 13.933 11.2969C14.3193 12.0907 15.1275 12.5215 15.9994 12.4649C16.8561 12.4079 17.746 11.911 17.7213 13.1558C17.7123 13.596 17.8044 13.9015 17.9396 14.3108C18.0649 14.6881 18.0564 15.0538 18.0851 15.4432C18.1381 16.171 18.272 16.9867 18.6332 17.6296L19.307 16.679C19.3901 16.5613 19.564 16.3965 19.6053 16.2577C19.6785 16.0119 19.5343 15.5897 19.5177 15.3143C19.5011 15.0389 19.5092 14.76 19.4669 14.4846C19.4076 14.0987 19.1794 13.7371 19.148 13.3557C19.09 12.6455 19.2199 12.0786 18.6727 11.4847C18.1444 10.912 17.37 10.7745 16.6301 10.8909C16.2573 10.9492 14.7564 11.1891 15.3588 10.337C15.4779 10.1694 15.6859 10.0319 15.8197 9.87247C15.9361 9.73366 16.0371 9.47851 16.1737 9.37024C16.3103 9.26198 16.9374 9.13755 17.1171 9.1928C17.2968 9.24806 17.4841 9.50726 17.64 9.62226C17.928 9.83918 18.2641 9.98342 18.6197 10.0427C19.2333 10.1326 20.5163 9.77589 20.5064 8.98886C20.5046 8.61151 20.1542 8.08593 20.0159 7.73284Z" fill="currentColor"/>
					<path d="M12.9128 14.2088C12.6733 13.2007 11.3037 12.8638 10.5652 12.3171C10.1406 12.0026 9.76285 11.517 9.20537 11.4775C8.94841 11.4591 8.73324 11.5148 8.47853 11.4488C8.24494 11.3886 8.06166 11.2628 7.81279 11.2956C7.34785 11.3567 7.05451 11.8535 6.55498 11.7861C6.08105 11.7223 5.59275 11.168 5.48494 10.7165C5.34658 10.1361 5.80568 9.94792 6.29757 9.89626C6.50287 9.8747 6.73332 9.85134 6.93052 9.92636C7.19017 10.0229 7.31281 10.2772 7.54595 10.4057C7.98304 10.6451 8.07154 10.2624 8.00461 9.87425C7.90443 9.29296 7.78763 9.05577 8.30603 8.65597C8.66541 8.38015 8.97267 8.1807 8.91517 7.68521C8.88103 7.39411 8.72156 7.26249 8.87025 6.97275C8.983 6.75218 9.29252 6.55318 9.49421 6.42155C10.0149 6.08195 11.7246 6.1071 11.026 5.15655C10.8208 4.87759 10.4421 4.37896 10.0827 4.31068C9.63347 4.22577 9.43402 4.7271 9.12091 4.94812C8.79748 5.17677 8.16767 5.43642 7.84378 5.08288C7.40804 4.60716 8.13263 4.45083 8.293 4.11886C8.45337 3.78689 7.9215 3.15933 7.63669 3.00031L6.29757 4.50204C6.25911 4.75354 6.2725 5.01025 6.33693 5.25638C6.40136 5.50251 6.51546 5.73286 6.67222 5.93325C6.93861 6.27601 7.36267 6.38607 7.38199 6.85415C7.40086 7.30337 7.33078 7.53337 7.03699 7.84917C6.90986 7.98394 6.82002 8.1753 6.69064 8.30154C6.53207 8.45562 6.59091 8.40845 6.34339 8.45068C5.878 8.52929 5.48179 8.65058 5.03212 8.77456C4.28283 8.98165 4.21365 7.75753 3.87224 7.27732L2.7492 8.18429C2.73707 8.33298 2.93338 8.60655 2.98683 8.76827C3.29365 9.69232 3.91267 10.407 4.31248 11.2911C4.73339 12.2273 5.86363 11.9676 6.36271 12.7879C6.80564 13.5156 6.33261 14.437 6.66414 15.1988C6.90492 15.7518 7.47273 15.8727 7.86445 16.277C8.2647 16.6853 8.25617 17.2441 8.31726 17.7756C8.38616 18.4006 8.49798 19.0202 8.65193 19.6299C8.70628 19.8406 8.75615 20.1191 8.90035 20.293C8.99918 20.4125 9.33834 20.5153 9.20132 20.5549C9.39269 20.5863 9.73365 20.7651 9.89312 20.6339C10.1034 20.4614 10.0472 19.9305 10.0836 19.6906C10.1927 18.9763 10.5503 18.2778 11.0328 17.7432C11.5094 17.2158 12.1626 16.8587 12.5651 16.2608C12.9572 15.6777 13.0754 14.8911 12.9128 14.2088ZM11.4128 15.3911C11.1433 15.8722 10.5431 16.1943 10.1573 16.5766C10.0526 16.6804 9.82978 17.0397 9.69861 16.962C9.60472 16.9063 9.57283 16.44 9.53824 16.3331C9.35979 15.7947 9.01913 15.3248 8.56298 14.9877C8.42238 14.8812 8.07378 14.7429 7.99337 14.5969C7.90353 14.4383 7.98439 14.0641 7.98753 13.8916C7.99248 13.64 7.87793 13.2218 7.93992 12.9932C8.01179 12.7295 7.87343 12.8885 8.10927 12.8364C8.23371 12.8085 8.74761 12.8988 8.90259 12.9312C9.14877 12.9824 9.28443 13.1356 9.47849 13.2906C9.9888 13.6998 10.5508 14.0165 11.1226 14.33C11.5656 14.5753 11.6958 14.8857 11.4128 15.3911Z" fill="currentColor"/>
					<path d="M8.28625 3.01382C8.49918 3.22181 8.69954 3.46798 9.01713 3.48864C9.31766 3.50886 9.60112 3.34624 9.86346 3.55064C10.1546 3.77525 10.3643 4.0596 10.7507 4.12968C11.1244 4.19751 11.5202 3.97919 11.6127 3.59691C11.7026 3.23259 11.509 2.83638 11.4973 2.47071C11.4973 2.41995 11.5247 2.19444 11.4896 2.15626C11.4636 2.12751 11.2462 2.15985 11.2129 2.16075C10.9694 2.16794 10.7266 2.18471 10.4843 2.21107C9.60104 2.30667 8.73605 2.52828 7.91565 2.86917C8.02481 2.94464 8.16182 2.97474 8.28625 3.01382Z" fill="currentColor"/>
					<path d="M16.0102 5.53751C16.3916 5.53751 16.7788 5.36681 16.6557 4.92568C16.5524 4.55597 16.3763 4.15482 15.9477 4.35427C15.6751 4.48095 15.2887 4.80349 15.2568 5.12333C15.2204 5.4863 15.7559 5.53751 16.0102 5.53751Z" fill="currentColor"/>
					<path d="M15.7056 7.4678C16.095 7.70095 16.6727 7.59134 16.9665 7.25847C17.1961 6.99792 17.3313 6.54556 17.7441 6.54601C17.9259 6.54563 18.1005 6.61679 18.2302 6.74411C18.4009 6.92066 18.3672 7.08642 18.4036 7.30743C18.4849 7.80382 19.0172 7.33573 19.156 7.14347C19.2459 7.01814 19.3676 6.83216 19.3267 6.66909C19.289 6.51681 19.1111 6.35464 19.032 6.21493C18.8011 5.81064 18.6111 5.3403 18.2652 5.01372C17.9323 4.69927 17.5231 4.73566 17.2073 5.06224C16.9486 5.33177 16.648 5.54515 16.471 5.87308C16.3461 6.10353 16.2055 6.21358 15.9526 6.27333C15.8134 6.30612 15.6544 6.31825 15.5376 6.41169C15.2123 6.66774 15.3974 7.28273 15.7056 7.4678Z" fill="currentColor"/>
				</svg>

				<?php foreach($languages_array as $language_item) { ?>
					<div class="item<?php echo esc_attr(($language_item['current_lang']) ? ' current' : '') ?>"><a href="<?php echo esc_url($language_item['url']) ?>"><?php echo strip_tags($language_item['slug']) ?></a></div>
				<?php } ?>
			</div>
			<?php
		}
	}

	new Header_Builder_View_Language($this->header_css);
}