<?php

function novo_iconpicker_css() {
	wp_enqueue_style( 'novo-icons' );
}
add_action( 'wp_enqueue_scripts', 'novo_iconpicker_css', 100 );

add_action( 'admin_enqueue_scripts', 'load_iconpicker_styles', 100 );
function load_iconpicker_styles() {
	wp_enqueue_style( 'novo-icons' );
}

add_filter( 'vc_iconpicker-type-fontawesome', 'novo_iconpicker' );
/**
 * Material icon set from Google
 * @since 5.0
 *
 * @param $icons
 *
 * @return array
 */
function novo_iconpicker( $icons = array() ) {
	$novo = array(
		'Base UI (Novo Pack)' => array(
			array( 'basic-ui-icon-bag' => 'bag'),
			array( 'basic-ui-icon-battery' => 'battery'),
			array( 'basic-ui-icon-bell' => 'bell'),
			array( 'basic-ui-icon-bluetooth' => 'bluetooth'),
			array( 'basic-ui-icon-bookmark' => 'bookmark'),
			array( 'basic-ui-icon-briefcase' => 'briefcase'),
			array( 'basic-ui-icon-calendar' => 'calendar'),
			array( 'basic-ui-icon-cancel' => 'cancel'),
			array( 'basic-ui-icon-cancel-1' => 'cancel'),
			array( 'basic-ui-icon-clip' => 'clip'),
			array( 'basic-ui-icon-clock' => 'clock'),
			array( 'basic-ui-icon-clock-1' => 'clock'),
			array( 'basic-ui-icon-cloud' => 'cloud'),
			array( 'basic-ui-icon-correct' => 'correct'),
			array( 'basic-ui-icon-credit-card' => 'credit card'),
			array( 'basic-ui-icon-cursor' => 'cursor'),
			array( 'basic-ui-icon-cursor-1' => 'cursor'),
			array( 'basic-ui-icon-cut' => 'cut'),
			array( 'basic-ui-icon-cutlery' => 'cutlery'),
			array( 'basic-ui-icon-down-arrow' => 'down arrow'),
			array( 'basic-ui-icon-download' => 'download'),
			array( 'basic-ui-icon-edit' => 'edit'),
			array( 'basic-ui-icon-envelope' => 'envelope'),
			array( 'basic-ui-icon-export' => 'export'),
			array( 'basic-ui-icon-favorite' => 'favorite'),
			array( 'basic-ui-icon-file' => 'file'),
			array( 'basic-ui-icon-folder' => 'folder'),
			array( 'basic-ui-icon-forward' => 'forward'),
			array( 'basic-ui-icon-gallery' => 'gallery'),
			array( 'basic-ui-icon-gamepad' => 'gamepad'),
			array( 'basic-ui-icon-garbage' => 'garbage'),
			array( 'basic-ui-icon-headphones' => 'headphones'),
			array( 'basic-ui-icon-heart' => 'heart'),
			array( 'basic-ui-icon-help' => 'help'),
			array( 'basic-ui-icon-home' => 'home'),
			array( 'basic-ui-icon-hourglass' => 'hourglass'),
			array( 'basic-ui-icon-info' => 'info'),
			array( 'basic-ui-icon-layer' => 'layer'),
			array( 'basic-ui-icon-layout' => 'layout'),
			array( 'basic-ui-icon-left-arrow' => 'left arrow'),
			array( 'basic-ui-icon-left-arrow-1' => 'left arrow'),
			array( 'basic-ui-icon-lightning' => 'lightning'),
			array( 'basic-ui-icon-link' => 'link'),
			array( 'basic-ui-icon-logout' => 'logout'),
			array( 'basic-ui-icon-magnet' => 'magnet'),
			array( 'basic-ui-icon-map' => 'map'),
			array( 'basic-ui-icon-menu' => 'menu'),
			array( 'basic-ui-icon-monitor' => 'monitor'),
			array( 'basic-ui-icon-moon' => 'moon'),
			array( 'basic-ui-icon-padnote' => 'padnote'),
			array( 'basic-ui-icon-paint' => 'paint'),
			array( 'basic-ui-icon-pause' => 'pause'),
			array( 'basic-ui-icon-photo-camera' => 'photo camera'),
			array( 'basic-ui-icon-placeholder' => 'placeholder'),
			array( 'basic-ui-icon-play-button' => 'play button'),
			array( 'basic-ui-icon-power' => 'power'),
			array( 'basic-ui-icon-presentation' => 'presentation'),
			array( 'basic-ui-icon-printer' => 'printer'),
			array( 'basic-ui-icon-profile' => 'profile'),
			array( 'basic-ui-icon-prohibition' => 'prohibition'),
			array( 'basic-ui-icon-push-pin' => 'push pin'),
			array( 'basic-ui-icon-puzzle' => 'puzzle'),
			array( 'basic-ui-icon-refresh' => 'refresh'),
			array( 'basic-ui-icon-remove' => 'remove'),
			array( 'basic-ui-icon-rewind' => 'rewind'),
			array( 'basic-ui-icon-right-arrow' => 'right arrow'),
			array( 'basic-ui-icon-right-arrow-1' => 'right arrow'),
			array( 'basic-ui-icon-rocket-launch' => 'rocket launch'),
			array( 'basic-ui-icon-screen' => 'screen'),
			array( 'basic-ui-icon-search' => 'search'),
			array( 'basic-ui-icon-settings' => 'settings'),
			array( 'basic-ui-icon-settings-1' => 'settings'),
			array( 'basic-ui-icon-settings-2' => 'settings'),
			array( 'basic-ui-icon-share' => 'share'),
			array( 'basic-ui-icon-shield' => 'shield'),
			array( 'basic-ui-icon-shopping-cart' => 'shopping cart'),
			array( 'basic-ui-icon-shutter' => 'shutter'),
			array( 'basic-ui-icon-smartphone' => 'smartphone'),
			array( 'basic-ui-icon-speech-bubble' => 'speech bubble'),
			array( 'basic-ui-icon-speedometer' => 'speedometer'),
			array( 'basic-ui-icon-stats' => 'stats'),
			array( 'basic-ui-icon-store' => 'store'),
			array( 'basic-ui-icon-sun' => 'sun'),
			array( 'basic-ui-icon-switch' => 'switch'),
			array( 'basic-ui-icon-tag' => 'tag'),
			array( 'basic-ui-icon-target' => 'target'),
			array( 'basic-ui-icon-timer' => 'timer'),
			array( 'basic-ui-icon-unlock' => 'unlock'),
			array( 'basic-ui-icon-up-arrow' => 'up arrow'),
			array( 'basic-ui-icon-upload' => 'upload'),
			array( 'basic-ui-icon-video' => 'video'),
			array( 'basic-ui-icon-video-camera' => 'video camera'),
			array( 'basic-ui-icon-visible' => 'visible'),
			array( 'basic-ui-icon-voice-recorder' => 'voice recorder'),
			array( 'basic-ui-icon-volume' => 'volume'),
			array( 'basic-ui-icon-waiting' => 'waiting'),
			array( 'basic-ui-icon-wifi' => 'wifi'),
			array( 'basic-ui-icon-zoom' => 'zoom'),
			array( 'basic-ui-icon-zoom-out' => 'zoom out'),
			array( 'basic-ui-icon-add' => 'add'),
		),
		'Photo (Novo Pack)' => array(
			array( 'photo-icon-automatic-picture' => 'automatic picture'),
			array( 'photo-icon-battery-status' => 'battery status'),
			array( 'photo-icon-bit-map-editor' => 'bit map editor'),
			array( 'photo-icon-box-film' => 'box film'),
			array( 'photo-icon-brightness' => 'brightness'),
			array( 'photo-icon-camera-display' => 'camera display'),
			array( 'photo-icon-camera-flash' => 'camera flash'),
			array( 'photo-icon-camera-lens' => 'camera lens'),
			array( 'photo-icon-camera-side-view' => 'camera side view'),
			array( 'photo-icon-camera-synchronation' => 'camera synchronation'),
			array( 'photo-icon-camera-top-view' => 'camera top view'),
			array( 'photo-icon-camera-viewfinder' => 'camera viewfinder'),
			array( 'photo-icon-camera-with-flash' => 'camera with flash'),
			array( 'photo-icon-camera-with-flash-1' => 'camera with flash'),
			array( 'photo-icon-closed-aperture' => 'closed aperture'),
			array( 'photo-icon-compact-camera' => 'compact camera'),
			array( 'photo-icon-compression' => 'compression'),
			array( 'photo-icon-decrease' => 'decrease'),
			array( 'photo-icon-empty-battery' => 'empty battery'),
			array( 'photo-icon-eye' => 'eye'),
			array( 'photo-icon-flash-card' => 'flash card'),
			array( 'photo-icon-flash-symbol' => 'flash symbol'),
			array( 'photo-icon-focus-persons' => 'focus persons'),
			array( 'photo-icon-girl-photography' => 'girl photography'),
			array( 'photo-icon-golden-section' => 'golden section'),
			array( 'photo-icon-increase' => 'increase'),
			array( 'photo-icon-landscape-photo' => 'landscape photo'),
			array( 'photo-icon-large-format-camera' => 'large format camera'),
			array( 'photo-icon-led-spotlight' => 'led spotlight'),
			array( 'photo-icon-leica-camera' => 'leica camera'),
			array( 'photo-icon-len' => 'len'),
			array( 'photo-icon-macro' => 'macro'),
			array( 'photo-icon-medium-format-camera' => 'medium format camera'),
			array( 'photo-icon-night-protrait' => 'night protrait'),
			array( 'photo-icon-no-flash' => 'no flash'),
			array( 'photo-icon-opening-aperture' => 'opening aperture'),
			array( 'photo-icon-panorama' => 'panorama'),
			array( 'photo-icon-photo-camera' => 'photo camera'),
			array( 'photo-icon-photo-film' => 'photo film'),
			array( 'photo-icon-photographer-with-camera' => 'photographer with camera'),
			array( 'photo-icon-picture-in-a-frame' => 'picture in a frame'),
			array( 'photo-icon-polaroid-camera' => 'polaroid camera'),
			array( 'photo-icon-polaroid-photo' => 'polaroid photo'),
			array( 'photo-icon-printing-photo' => 'printing photo'),
			array( 'photo-icon-recycling-bin' => 'recycling bin'),
			array( 'photo-icon-softbox' => 'softbox'),
			array( 'photo-icon-stretching' => 'stretching'),
			array( 'photo-icon-timer' => 'timer'),
			array( 'photo-icon-tripod-with-camera' => 'tripod with camera'),
			array( 'photo-icon-usb-connection' => 'usb connection'),
		),
		'Multimedia (Novo Pack)' => array(
			array( 'multimedia-icon-add' => 'add'),
			array( 'multimedia-icon-add-1' => 'add'),
			array( 'multimedia-icon-add-user' => 'add user'),
			array( 'multimedia-icon-anchor' => 'anchor'),
			array( 'multimedia-icon-back' => 'back'),
			array( 'multimedia-icon-back-1' => 'back'),
			array( 'multimedia-icon-back-2' => 'back'),
			array( 'multimedia-icon-back-3' => 'back'),
			array( 'multimedia-icon-back-4' => 'back'),
			array( 'multimedia-icon-back-5' => 'back'),
			array( 'multimedia-icon-back-6' => 'back'),
			array( 'multimedia-icon-back-7' => 'back'),
			array( 'multimedia-icon-back-8' => 'back'),
			array( 'multimedia-icon-battery' => 'battery'),
			array( 'multimedia-icon-bell' => 'bell'),
			array( 'multimedia-icon-box' => 'box'),
			array( 'multimedia-icon-brightness' => 'brightness'),
			array( 'multimedia-icon-brightness-1' => 'brightness'),
			array( 'multimedia-icon-browser' => 'browser'),
			array( 'multimedia-icon-browser-1' => 'browser'),
			array( 'multimedia-icon-cancel' => 'cancel'),
			array( 'multimedia-icon-cancel-1' => 'cancel'),
			array( 'multimedia-icon-checked' => 'checked'),
			array( 'multimedia-icon-clipboard' => 'clipboard'),
			array( 'multimedia-icon-clock' => 'clock'),
			array( 'multimedia-icon-cloud' => 'cloud'),
			array( 'multimedia-icon-coffee-cup' => 'coffee cup'),
			array( 'multimedia-icon-computer' => 'computer'),
			array( 'multimedia-icon-down-arrow' => 'down arrow'),
			array( 'multimedia-icon-down-arrow-1' => 'down arrow'),
			array( 'multimedia-icon-down-arrow-2' => 'down arrow'),
			array( 'multimedia-icon-down-arrow-3' => 'down arrow'),
			array( 'multimedia-icon-down-arrow-4' => 'down arrow'),
			array( 'multimedia-icon-download' => 'download'),
			array( 'multimedia-icon-download-1' => 'download'),
			array( 'multimedia-icon-download-2' => 'download'),
			array( 'multimedia-icon-envelope' => 'envelope'),
			array( 'multimedia-icon-exclamation' => 'exclamation'),
			array( 'multimedia-icon-exclamation-1' => 'exclamation'),
			array( 'multimedia-icon-eye' => 'eye'),
			array( 'multimedia-icon-fast-forward' => 'fast forward'),
			array( 'multimedia-icon-fast-forward-1' => 'fast forward'),
			array( 'multimedia-icon-file' => 'file'),
			array( 'multimedia-icon-flag' => 'flag'),
			array( 'multimedia-icon-folder' => 'folder'),
			array( 'multimedia-icon-forbidden' => 'forbidden'),
			array( 'multimedia-icon-full' => 'full'),
			array( 'multimedia-icon-heart' => 'heart'),
			array( 'multimedia-icon-help' => 'help'),
			array( 'multimedia-icon-home' => 'home'),
			array( 'multimedia-icon-info' => 'info'),
			array( 'multimedia-icon-key' => 'key'),
			array( 'multimedia-icon-key-1' => 'key'),
			array( 'multimedia-icon-light-bulb' => 'light bulb'),
			array( 'multimedia-icon-list' => 'list'),
			array( 'multimedia-icon-loading' => 'loading'),
			array( 'multimedia-icon-locate' => 'locate'),
			array( 'multimedia-icon-medal' => 'medal'),
			array( 'multimedia-icon-menu' => 'menu'),
			array( 'multimedia-icon-menu-1' => 'menu'),
			array( 'multimedia-icon-microphone' => 'microphone'),
			array( 'multimedia-icon-minus' => 'minus'),
			array( 'multimedia-icon-minus-1' => 'minus'),
			array( 'multimedia-icon-moon' => 'moon'),
			array( 'multimedia-icon-more' => 'more'),
			array( 'multimedia-icon-move' => 'move'),
			array( 'multimedia-icon-musical-note' => 'musical note'),
			array( 'multimedia-icon-musical-note-1' => 'musical note'),
			array( 'multimedia-icon-mute' => 'mute'),
			array( 'multimedia-icon-next' => 'next'),
			array( 'multimedia-icon-next-1' => 'next'),
			array( 'multimedia-icon-next-2' => 'next'),
			array( 'multimedia-icon-next-3' => 'next'),
			array( 'multimedia-icon-next-4' => 'next'),
			array( 'multimedia-icon-next-5' => 'next'),
			array( 'multimedia-icon-next-6' => 'next'),
			array( 'multimedia-icon-next-7' => 'next'),
			array( 'multimedia-icon-orientation' => 'orientation'),
			array( 'multimedia-icon-paint-brush' => 'paint brush'),
			array( 'multimedia-icon-pause' => 'pause'),
			array( 'multimedia-icon-pause-1' => 'pause'),
			array( 'multimedia-icon-phone-call' => 'phone call'),
			array( 'multimedia-icon-photo-camera' => 'photo camera'),
			array( 'multimedia-icon-photo-camera-1' => 'photo camera'),
			array( 'multimedia-icon-placeholder' => 'placeholder'),
			array( 'multimedia-icon-play' => 'play'),
			array( 'multimedia-icon-play-button' => 'play button'),
			array( 'multimedia-icon-play-button-1' => 'play button'),
			array( 'multimedia-icon-question' => 'question'),
			array( 'multimedia-icon-question-1' => 'question'),
			array( 'multimedia-icon-question-2' => 'question'),
			array( 'multimedia-icon-question-3' => 'question'),
			array( 'multimedia-icon-record' => 'record'),
			array( 'multimedia-icon-record-1' => 'record'),
			array( 'multimedia-icon-refresh' => 'refresh'),
			array( 'multimedia-icon-refresh-1' => 'refresh'),
			array( 'multimedia-icon-remove-user' => 'remove user'),
			array( 'multimedia-icon-rewind' => 'rewind'),
			array( 'multimedia-icon-rewind-1' => 'rewind'),
			array( 'multimedia-icon-rocket-ship' => 'rocket ship'),
			array( 'multimedia-icon-screen' => 'screen'),
			array( 'multimedia-icon-search' => 'search'),
			array( 'multimedia-icon-search-1' => 'search'),
			array( 'multimedia-icon-security' => 'security'),
			array( 'multimedia-icon-settings' => 'settings'),
			array( 'multimedia-icon-share' => 'share'),
			array( 'multimedia-icon-share-1' => 'share'),
			array( 'multimedia-icon-shopping-cart' => 'shopping cart'),
			array( 'multimedia-icon-shopping-cart-1' => 'shopping cart'),
			array( 'multimedia-icon-sign-in' => 'sign in'),
			array( 'multimedia-icon-sign-in-1' => 'sign in'),
			array( 'multimedia-icon-smartphone' => 'smartphone'),
			array( 'multimedia-icon-speech-bubble' => 'speech bubble'),
			array( 'multimedia-icon-speech-bubble-1' => 'speech bubble'),
			array( 'multimedia-icon-speech-bubble-2' => 'speech bubble'),
			array( 'multimedia-icon-star' => 'star'),
			array( 'multimedia-icon-stats' => 'stats'),
			array( 'multimedia-icon-stop' => 'stop'),
			array( 'multimedia-icon-stop-1' => 'stop'),
			array( 'multimedia-icon-suitcase' => 'suitcase'),
			array( 'multimedia-icon-sync' => 'sync'),
			array( 'multimedia-icon-sync-1' => 'sync'),
			array( 'multimedia-icon-tablet' => 'tablet'),
			array( 'multimedia-icon-tags' => 'tags'),
			array( 'multimedia-icon-tape' => 'tape'),
			array( 'multimedia-icon-target' => 'target'),
			array( 'multimedia-icon-test-tube' => 'test tube'),
			array( 'multimedia-icon-test-tube-1' => 'test tube'),
			array( 'multimedia-icon-text-lines' => 'text lines'),
			array( 'multimedia-icon-thunder' => 'thunder'),
			array( 'multimedia-icon-trash' => 'trash'),
			array( 'multimedia-icon-unlocked' => 'unlocked'),
			array( 'multimedia-icon-up-arrow' => 'up arrow'),
			array( 'multimedia-icon-up-arrow-1' => 'up arrow'),
			array( 'multimedia-icon-up-arrow-2' => 'up arrow'),
			array( 'multimedia-icon-up-arrow-3' => 'up arrow'),
			array( 'multimedia-icon-upload' => 'upload'),
			array( 'multimedia-icon-upload-1' => 'upload'),
			array( 'multimedia-icon-upload-2' => 'upload'),
			array( 'multimedia-icon-user' => 'user'),
			array( 'multimedia-icon-user-1' => 'user'),
			array( 'multimedia-icon-users' => 'users'),
			array( 'multimedia-icon-video-camera' => 'video camera'),
			array( 'multimedia-icon-volume' => 'volume'),
			array( 'multimedia-icon-warning' => 'warning'),
			array( 'multimedia-icon-warning-1' => 'warning'),
			array( 'multimedia-icon-wifi' => 'wifi'),
			array( 'multimedia-icon-wifi-1' => 'wifi'),
			array( 'multimedia-icon-wine-glass' => 'wine glass'),
			array( 'multimedia-icon-wine-glass-1' => 'wine glass'),
			array( 'multimedia-icon-zoom-in' => 'zoom in'),
			array( 'multimedia-icon-zoom-out' => 'zoom out'),
		),
		'Web Application (Novo Pack)' => array(
			array( 'web-application-icon-add-folder-button' => 'add folder button'),
			array( 'web-application-icon-address-book' => 'address book'),
			array( 'web-application-icon-alarm-button' => 'alarm button'),
			array( 'web-application-icon-award-badge' => 'award badge'),
			array( 'web-application-icon-award-badge-1' => 'award badge'),
			array( 'web-application-icon-award-badge-2' => 'award badge 2'),
			array( 'web-application-icon-award-medal' => 'award medal'),
			array( 'web-application-icon-baguette' => 'baguette'),
			array( 'web-application-icon-basic-burger' => 'basic burger'),
			array( 'web-application-icon-basic-calculator' => 'basic calculator'),
			array( 'web-application-icon-basic-compass' => 'basic compass'),
			array( 'web-application-icon-basic-mathematical-symbols' => 'basic mathematical symbols'),
			array( 'web-application-icon-basic-microphone' => 'basic microphone'),
			array( 'web-application-icon-basic-moon' => 'basic moon'),
			array( 'web-application-icon-basic-plug' => 'basic plug'),
			array( 'web-application-icon-basic-rainbow' => 'basic rainbow'),
			array( 'web-application-icon-basic-square' => 'basic square'),
			array( 'web-application-icon-basic-umbrella' => 'basic umbrella'),
			array( 'web-application-icon-battery-medium-charge' => 'battery medium charge'),
			array( 'web-application-icon-bicycle-side-view' => 'bicycle side view'),
			array( 'web-application-icon-big-diamond' => 'big diamond'),
			array( 'web-application-icon-big-safe' => 'big safe'),
			array( 'web-application-icon-bitten-ice-cream' => 'bitten ice cream'),
			array( 'web-application-icon-blank-circle' => 'blank circle'),
			array( 'web-application-icon-blank-cube' => 'blank cube'),
			array( 'web-application-icon-blank-left-arrow' => 'blank left arrow'),
			array( 'web-application-icon-boot-for-women' => 'boot for women'),
			array( 'web-application-icon-briefcase-outline' => 'briefcase outline'),
			array( 'web-application-icon-broken-disc' => 'broken disc'),
			array( 'web-application-icon-calendar-with-six-days' => 'calendar with six days'),
			array( 'web-application-icon-camera-shutter' => 'camera shutter'),
			array( 'web-application-icon-cell-tower' => 'cell tower'),
			array( 'web-application-icon-champagne-bottle' => 'champagne bottle'),
			array( 'web-application-icon-charged-battery' => 'charged battery'),
			array( 'web-application-icon-check-box-with-cursor' => 'check box with cursor'),
			array( 'web-application-icon-check-list' => 'check list'),
			array( 'web-application-icon-chef-hat' => 'chef hat'),
			array( 'web-application-icon-cocktail-glass' => 'cocktail glass'),
			array( 'web-application-icon-coffee-cup-with-steam' => 'coffee cup with steam'),
			array( 'web-application-icon-connection-signal' => 'connection signal'),
			array( 'web-application-icon-credit-card' => 'credit card'),
			array( 'web-application-icon-crop-button' => 'crop button'),
			array( 'web-application-icon-cross-outline' => 'cross outline'),
			array( 'web-application-icon-delete-button' => 'delete button'),
			array( 'web-application-icon-digital-phone' => 'digital phone'),
			array( 'web-application-icon-download-arrow' => 'download arrow'),
			array( 'web-application-icon-drawing-tablet' => 'drawing tablet'),
			array( 'web-application-icon-earth-globe' => 'earth globe'),
			array( 'web-application-icon-earth-globe-1' => 'earth globe'),
			array( 'web-application-icon-edit-button' => 'edit button'),
			array( 'web-application-icon-eighth-note' => 'eighth note'),
			array( 'web-application-icon-electric-bell' => 'electric bell'),
			array( 'web-application-icon-electric-fan' => 'electric fan'),
			array( 'web-application-icon-email-envelope-button' => 'email envelope button'),
			array( 'web-application-icon-empty-box' => 'empty box'),
			array( 'web-application-icon-exit-full-screen-arrows' => 'exit full screen arrows'),
			array( 'web-application-icon-exit-right-arrow' => 'exit right arrow'),
			array( 'web-application-icon-expand-arrows' => 'expand arrows'),
			array( 'web-application-icon-expand-button' => 'expand button'),
			array( 'web-application-icon-extract-button' => 'extract button'),
			array( 'web-application-icon-eye-close-up-visibility-button' => 'eye close up visibility button'),
			array( 'web-application-icon-fast-forward' => 'fast forward'),
			array( 'web-application-icon-female-symbol' => 'female symbol'),
			array( 'web-application-icon-file-folder' => 'file folder'),
			array( 'web-application-icon-flashlight' => 'flashlight'),
			array( 'web-application-icon-floppy-disk-save-button' => 'floppy disk save button'),
			array( 'web-application-icon-folded-map-with-position-mark' => 'folded map with position mark'),
			array( 'web-application-icon-folding-chair' => 'folding chair'),
			array( 'web-application-icon-fried-egg' => 'fried egg'),
			array( 'web-application-icon-front-store-with-awning' => 'front store with awning'),
			array( 'web-application-icon-front-webcam' => 'front webcam'),
			array( 'web-application-icon-gamepad' => 'gamepad'),
			array( 'web-application-icon-half-filled-cocktail-glass' => 'half filled cocktail glass'),
			array( 'web-application-icon-halloween-ghost' => 'halloween ghost'),
			array( 'web-application-icon-hammer' => 'hammer'),
			array( 'web-application-icon-hanging-bell' => 'hanging bell'),
			array( 'web-application-icon-happy-face' => 'happy face'),
			array( 'web-application-icon-headset' => 'headset'),
			array( 'web-application-icon-heart-outline' => 'heart outline'),
			array( 'web-application-icon-high-volume-loudspeaker' => 'high volume loudspeaker'),
			array( 'web-application-icon-home-button' => 'home button'),
			array( 'web-application-icon-home-button-1' => 'home button'),
			array( 'web-application-icon-imac' => 'imac'),
			array( 'web-application-icon-keep-in-box' => 'keep in box'),
			array( 'web-application-icon-key-ring-with-two-keys' => 'key ring with two keys'),
			array( 'web-application-icon-kitchen-tools' => 'kitchen tools'),
			array( 'web-application-icon-landscape-inside-frame' => 'landscape inside frame'),
			array( 'web-application-icon-left-arrow' => 'left arrow'),
			array( 'web-application-icon-left-arrow-1' => 'left arrow'),
			array( 'web-application-icon-left-arrow-2' => 'left arrow 2'),
			array( 'web-application-icon-left-arrow-3' => 'left arrow 3'),
			array( 'web-application-icon-lemon-slice' => 'lemon slice'),
			array( 'web-application-icon-letter-with-stamp' => 'letter with stamp'),
			array( 'web-application-icon-lightning-flash' => 'lightning flash'),
			array( 'web-application-icon-link-button' => 'link button'),
			array( 'web-application-icon-list-button' => 'list button'),
			array( 'web-application-icon-list-layout-with-check-boxes' => 'list layout with check boxes'),
			array( 'web-application-icon-location-mark' => 'location mark'),
			array( 'web-application-icon-location-marker' => 'location marker'),
			array( 'web-application-icon-locked-padlock' => 'locked padlock'),
			array( 'web-application-icon-loop-arrow' => 'loop arrow'),
			array( 'web-application-icon-magic-wand-button' => 'magic wand button'),
			array( 'web-application-icon-magnifying-glass-search-button' => 'magnifying glass search button'),
			array( 'web-application-icon-male-symbol' => 'male symbol'),
			array( 'web-application-icon-man-underwear' => 'man underwear'),
			array( 'web-application-icon-megaphone' => 'megaphone'),
			array( 'web-application-icon-movie-clip-button' => 'movie clip button'),
			array( 'web-application-icon-musical-sixteenth-note' => 'musical sixteenth note'),
			array( 'web-application-icon-music-control-settings-button' => 'music control settings button'),
			array( 'web-application-icon-new-tab-button' => 'new tab button'),
			array( 'web-application-icon-open-diary' => 'open diary'),
			array( 'web-application-icon-open-drawer' => 'open drawer'),
			array( 'web-application-icon-open-letter-read-email' => 'open letter read email'),
			array( 'web-application-icon-pac-man' => 'pac man'),
			array( 'web-application-icon-paint-roller' => 'paint roller'),
			array( 'web-application-icon-paper-plane' => 'paper plane'),
			array( 'web-application-icon-pause-button' => 'pause button'),
			array( 'web-application-icon-pitcher-with-levels' => 'pitcher with levels'),
			array( 'web-application-icon-pizza-slice' => 'pizza slice'),
			array( 'web-application-icon-plate-and-utensils' => 'plate and utensils'),
			array( 'web-application-icon-play-video-button' => 'play video button'),
			array( 'web-application-icon-previous-track-button' => 'previous track button'),
			array( 'web-application-icon-price-tag' => 'price tag'),
			array( 'web-application-icon-print-button' => 'print button'),
			array( 'web-application-icon-prohibition-sign' => 'prohibition sign'),
			array( 'web-application-icon-quotation-mark-inside-a-circle' => 'quotation mark inside a circle'),
			array( 'web-application-icon-radio' => 'radio'),
			array( 'web-application-icon-raining-sky' => 'raining sky'),
			array( 'web-application-icon-record-voice-button' => 'record voice button'),
			array( 'web-application-icon-refresh-arrows' => 'refresh arrows'),
			array( 'web-application-icon-refresh-arrows-1' => 'refresh arrows'),
			array( 'web-application-icon-refresh-button' => 'refresh button'),
			array( 'web-application-icon-refresh-left-arrow' => 'refresh left arrow'),
			array( 'web-application-icon-return-left-arrow' => 'return left arrow'),
			array( 'web-application-icon-right-arrow-play-button' => 'right arrow play button'),
			array( 'web-application-icon-road-with-broken-lines' => 'road with broken lines'),
			array( 'web-application-icon-rocket-vertical-position' => 'rocket vertical position'),
			array( 'web-application-icon-round-add-button' => 'round add button'),
			array( 'web-application-icon-round-delete-button' => 'round delete button'),
			array( 'web-application-icon-round-done-button' => 'round done button'),
			array( 'web-application-icon-rounded-delete-button-with-minus' => 'rounded delete button with minus'),
			array( 'web-application-icon-rounded-glasses' => 'rounded glasses'),
			array( 'web-application-icon-round-help-button' => 'round help button'),
			array( 'web-application-icon-round-information-button' => 'round information button'),
			array( 'web-application-icon-round-left-button' => 'round left button'),
			array( 'web-application-icon-round-loading-progress' => 'round loading progress'),
			array( 'web-application-icon-round-location-indicator' => 'round location indicator'),
			array( 'web-application-icon-round-right-arrow' => 'round right arrow'),
			array( 'web-application-icon-round-volume-button' => 'round volume button'),
			array( 'web-application-icon-sad-face' => 'sad face'),
			array( 'web-application-icon-settings-cogwheel-button' => 'settings cogwheel button'),
			array( 'web-application-icon-share-content' => 'share content'),
			array( 'web-application-icon-shining-sun' => 'shining sun'),
			array( 'web-application-icon-shopping-bag' => 'shopping bag'),
			array( 'web-application-icon-shuffle-arrows' => 'shuffle arrows'),
			array( 'web-application-icon-slide-to-unlock' => 'slide to unlock'),
			array( 'web-application-icon-small-battery-with-medium-charge' => 'small battery with medium charge'),
			array( 'web-application-icon-smartphone-outline' => 'smartphone outline'),
			array( 'web-application-icon-spanner-settings-button' => 'spanner settings button'),
			array( 'web-application-icon-speech-bubble' => 'speech bubble'),
			array( 'web-application-icon-speech-bubble-1' => 'speech bubble'),
			array( 'web-application-icon-speech-bubbles' => 'speech bubbles'),
			array( 'web-application-icon-speech-bubble-with-ellipsis' => 'speech bubble with ellipsis'),
			array( 'web-application-icon-sport-trophy' => 'sport trophy'),
			array( 'web-application-icon-sprig-with-five-leaves' => 'sprig with five leaves'),
			array( 'web-application-icon-statistical-chart' => 'statistical chart'),
			array( 'web-application-icon-sticking-plaster' => 'sticking plaster'),
			array( 'web-application-icon-subwoofer-speaker' => 'subwoofer speaker'),
			array( 'web-application-icon-switch-orientation-button' => 'switch orientation button'),
			array( 'web-application-icon-tablet-with-blank-screen' => 'tablet with blank screen'),
			array( 'web-application-icon-tack-save-button' => 'tack save button'),
			array( 'web-application-icon-tack-save-button-1' => 'tack save button'),
			array( 'web-application-icon-telephone-keypad' => 'telephone keypad'),
			array( 'web-application-icon-text-documents' => 'text documents'),
			array( 'web-application-icon-thermometer-high-temperature' => 'thermometer high temperature'),
			array( 'web-application-icon-tick-box' => 'tick box'),
			array( 'web-application-icon-top-load-washer' => 'top load washer'),
			array( 'web-application-icon-transgender-symbol' => 'transgender symbol'),
			array( 'web-application-icon-tree-leave' => 'tree leave'),
			array( 'web-application-icon-truck-side-view' => 'truck side view'),
			array( 'web-application-icon-two-left-arrows' => 'two left arrows'),
			array( 'web-application-icon-unfolded-map' => 'unfolded map'),
			array( 'web-application-icon-unfolded-map-with-location-mark' => 'unfolded map with location mark'),
			array( 'web-application-icon-unlocked-padlock' => 'unlocked padlock'),
			array( 'web-application-icon-up-arrow-fold-button' => 'up arrow fold button'),
			array( 'web-application-icon-upload-button' => 'upload button'),
			array( 'web-application-icon-user-with-speech-bubble' => 'user with speech bubble'),
			array( 'web-application-icon-voice-message-microphone-button' => 'voice message microphone button'),
			array( 'web-application-icon-volume-button' => 'volume button'),
			array( 'web-application-icon-volume-off-speaker' => 'volume off speaker'),
			array( 'web-application-icon-wall-clock' => 'wall clock'),
			array( 'web-application-icon-warning-sign' => 'warning sign'),
			array( 'web-application-icon-web-log-in' => 'web log in'),
			array( 'web-application-icon-web-mark-as-favorite-star' => 'web mark as favorite star'),
			array( 'web-application-icon-white-t-shirt' => 'white t shirt'),
			array( 'web-application-icon-widescreen-laptop' => 'widescreen laptop'),
			array( 'web-application-icon-wifi-signal' => 'wifi signal'),
			array( 'web-application-icon-wine-bottle' => 'wine bottle'),
			array( 'web-application-icon-wine-glass' => 'wine glass'),
			array( 'web-application-icon-yin-and-yang' => 'yin and yang'),
		),
		'Web Design (Novo Pack)' => array(
			array( 'web-design-icon-ai' => 'ai'),
			array( 'web-design-icon-allocation' => 'allocation'),
			array( 'web-design-icon-allocation-1' => 'allocation'),
			array( 'web-design-icon-allocation-2' => 'allocation'),
			array( 'web-design-icon-allocation-3' => 'allocation'),
			array( 'web-design-icon-attached' => 'attached'),
			array( 'web-design-icon-avatar' => 'avatar'),
			array( 'web-design-icon-avatar-1' => 'avatar'),
			array( 'web-design-icon-background' => 'background'),
			array( 'web-design-icon-background-1' => 'background'),
			array( 'web-design-icon-browser' => 'browser'),
			array( 'web-design-icon-browser-1' => 'browser'),
			array( 'web-design-icon-browser-2' => 'browser'),
			array( 'web-design-icon-browser-3' => 'browser'),
			array( 'web-design-icon-browser-4' => 'browser'),
			array( 'web-design-icon-browser-5' => 'browser'),
			array( 'web-design-icon-browser-6' => 'browser'),
			array( 'web-design-icon-browser-7' => 'browser'),
			array( 'web-design-icon-chat' => 'chat'),
			array( 'web-design-icon-cloud-computing' => 'cloud-computing'),
			array( 'web-design-icon-color-palette' => 'color-palette'),
			array( 'web-design-icon-compass' => 'compass'),
			array( 'web-design-icon-computer' => 'computer'),
			array( 'web-design-icon-crop' => 'crop'),
			array( 'web-design-icon-css' => 'css'),
			array( 'web-design-icon-cursor' => 'cursor'),
			array( 'web-design-icon-decrease' => 'decrease'),
			array( 'web-design-icon-desk' => 'desk'),
			array( 'web-design-icon-devices' => 'devices'),
			array( 'web-design-icon-devices-1' => 'devices'),
			array( 'web-design-icon-diagram' => 'diagram'),
			array( 'web-design-icon-diamond' => 'diamond'),
			array( 'web-design-icon-drop' => 'drop'),
			array( 'web-design-icon-eps' => 'eps'),
			array( 'web-design-icon-expand' => 'expand'),
			array( 'web-design-icon-folder' => 'folder'),
			array( 'web-design-icon-folder-1' => 'folder'),
			array( 'web-design-icon-folder-2' => 'folder'),
			array( 'web-design-icon-gif' => 'gif'),
			array( 'web-design-icon-gradient' => 'gradient'),
			array( 'web-design-icon-html' => 'html'),
			array( 'web-design-icon-image' => 'image'),
			array( 'web-design-icon-image-1' => 'image'),
			array( 'web-design-icon-image-2' => 'image'),
			array( 'web-design-icon-infographic' => 'infographic'),
			array( 'web-design-icon-jpg' => 'jpg'),
			array( 'web-design-icon-keyboard' => 'keyboard'),
			array( 'web-design-icon-landing-page' => 'landing-page'),
			array( 'web-design-icon-laptop' => 'laptop'),
			array( 'web-design-icon-levels' => 'levels'),
			array( 'web-design-icon-light-bulb' => 'light-bulb'),
			array( 'web-design-icon-link' => 'link'),
			array( 'web-design-icon-loupe' => 'loupe'),
			array( 'web-design-icon-magic-wand' => 'magic-wand'),
			array( 'web-design-icon-mask' => 'mask'),
			array( 'web-design-icon-monitor' => 'monitor'),
			array( 'web-design-icon-mouse' => 'mouse'),
			array( 'web-design-icon-notebook' => 'notebook'),
			array( 'web-design-icon-paint-roller' => 'paint-roller'),
			array( 'web-design-icon-pantone' => 'pantone'),
			array( 'web-design-icon-password' => 'password'),
			array( 'web-design-icon-pencil' => 'pencil'),
			array( 'web-design-icon-photo-camera' => 'photo-camera'),
			array( 'web-design-icon-pipette' => 'pipette'),
			array( 'web-design-icon-placeholder' => 'placeholder'),
			array( 'web-design-icon-png' => 'png'),
			array( 'web-design-icon-portfolio' => 'portfolio'),
			array( 'web-design-icon-profile' => 'profile'),
			array( 'web-design-icon-psd' => 'psd'),
			array( 'web-design-icon-rating' => 'rating'),
			array( 'web-design-icon-rgb' => 'rgb'),
			array( 'web-design-icon-ruler' => 'ruler'),
			array( 'web-design-icon-scissors' => 'scissors'),
			array( 'web-design-icon-sitemap' => 'sitemap'),
			array( 'web-design-icon-sketch' => 'sketch'),
			array( 'web-design-icon-sketchbook' => 'sketchbook'),
			array( 'web-design-icon-sliders' => 'sliders'),
			array( 'web-design-icon-sliders-1' => 'sliders'),
			array( 'web-design-icon-smartphone' => 'smartphone'),
			array( 'web-design-icon-smartphone-1' => 'smartphone'),
			array( 'web-design-icon-smartphone-2' => 'smartphone'),
			array( 'web-design-icon-smartphone-3' => 'smartphone'),
			array( 'web-design-icon-smartphone-4' => 'smartphone'),
			array( 'web-design-icon-smartphone-5' => 'smartphone'),
			array( 'web-design-icon-svg' => 'svg'),
			array( 'web-design-icon-tablet' => 'tablet'),
			array( 'web-design-icon-tablet-1' => 'tablet'),
			array( 'web-design-icon-tag' => 'tag'),
			array( 'web-design-icon-tap' => 'tap'),
			array( 'web-design-icon-tea-cup' => 'tea-cup'),
			array( 'web-design-icon-text-editor' => 'text-editor'),
			array( 'web-design-icon-text-editor-1' => 'text-editor'),
			array( 'web-design-icon-text-editor-2' => 'text-editor'),
			array( 'web-design-icon-text-height' => 'text-height'),
			array( 'web-design-icon-tracking' => 'tracking'),
			array( 'web-design-icon-vector' => 'vector'),
			array( 'web-design-icon-vector-1' => 'vector'),
			array( 'web-design-icon-vector-2' => 'vector'),
			array( 'web-design-icon-video-player' => 'video-player'),
			array( 'web-design-icon-web-design' => 'web-design'),
		),
		'Music & Multimedia (Novo Pack)' => array(
			array( 'music-and-multimedia-acoustic-guitar' => 'acoustic guitar' ),
			array( 'music-and-multimedia-backward-button' => 'backward button' ),
			array( 'music-and-multimedia-banjo' => 'banjo' ),
			array( 'music-and-multimedia-bell' => 'bell' ),
			array( 'music-and-multimedia-cassette' => 'cassette' ),
			array( 'music-and-multimedia-cd' => 'cd' ),
			array( 'music-and-multimedia-console-panel' => 'console panel' ),
			array( 'music-and-multimedia-drum' => 'drum' ),
			array( 'music-and-multimedia-drums' => 'drums' ),
			array( 'music-and-multimedia-drumsticks' => 'drumsticks' ),
			array( 'music-and-multimedia-earphones' => 'earphones' ),
			array( 'music-and-multimedia-eject-button' => 'eject button' ),
			array( 'music-and-multimedia-electric-guitar' => 'electric guitar' ),
			array( 'music-and-multimedia-equalizer' => 'equalizer' ),
			array( 'music-and-multimedia-fast-forward-button' => 'fast forward button' ),
			array( 'music-and-multimedia-gramophone' => 'gramophone' ),
			array( 'music-and-multimedia-grand-piano' => 'grand piano' ),
			array( 'music-and-multimedia-headphones' => 'headphones' ),
			array( 'music-and-multimedia-lyra' => 'lyra' ),
			array( 'music-and-multimedia-mandolin' => 'mandolin' ),
			array( 'music-and-multimedia-maracas' => 'maracas' ),
			array( 'music-and-multimedia-megaphone' => 'megaphone' ),
			array( 'music-and-multimedia-metronome' => 'metronome' ),
			array( 'music-and-multimedia-microphone' => 'microphone' ),
			array( 'music-and-multimedia-microphone-1' => 'microphone' ),
			array( 'music-and-multimedia-microphone-2' => 'microphone' ),
			array( 'music-and-multimedia-mp3-player' => 'mp3 player' ),
			array( 'music-and-multimedia-musical-note' => 'musical note' ),
			array( 'music-and-multimedia-musical-note-1' => 'musical note' ),
			array( 'music-and-multimedia-music-file' => 'music file' ),
			array( 'music-and-multimedia-music-folder' => 'music folder' ),
			array( 'music-and-multimedia-mute' => 'mute' ),
			array( 'music-and-multimedia-no-sound' => 'no sound' ),
			array( 'music-and-multimedia-pause-button' => 'pause button' ),
			array( 'music-and-multimedia-piano-keys' => 'piano keys' ),
			array( 'music-and-multimedia-play-button' => 'play button' ),
			array( 'music-and-multimedia-radio' => 'radio' ),
			array( 'music-and-multimedia-sound-frecuency' => 'sound frecuency' ),
			array( 'music-and-multimedia-speaker' => 'speaker' ),
			array( 'music-and-multimedia-speaker-1' => 'speaker' ),
			array( 'music-and-multimedia-speaker-with-waves' => 'speaker with waves' ),
			array( 'music-and-multimedia-triangle' => 'triangle' ),
			array( 'music-and-multimedia-trumpet' => 'trumpet' ),
			array( 'music-and-multimedia-tuning-fork' => 'tuning fork' ),
			array( 'music-and-multimedia-vdeo-cmera' => 'vdeo cmera' ),
			array( 'music-and-multimedia-video-camera' => 'video camera' ),
			array( 'music-and-multimedia-video-player' => 'video player' ),
			array( 'music-and-multimedia-violin' => 'violin' ),
			array( 'music-and-multimedia-xylophone' => 'xylophone' ),
		),
		'Brands (Novo Pack)' => array(
			array( 'fab fa-threads' => 'threads' ),
			array( 'fab fa-x-twitter' => 'twitter' ),
			array( 'fab fa-wirsindhandwerk' => 'wirsindhandwerk' ),
			array( 'fab fa-square-gitlab' => 'gitlab' ),
			array( 'fab fa-space-awesome' => 'space-awesome' ),
			array( 'fab fa-sitrox' => 'sitrox' ),
			array( 'fab fa-screenpal' => 'screenpal' ),
			array( 'fab fa-stubber' => 'stubber' ),
			array( 'fab fa-pix' => 'pix' ),
			array( 'fab fa-padlet' => 'padlet' ),
			array( 'fab fa-odysee' => 'odysee' ),
			array( 'fab fa-nfc-symbol' => 'nfc symbol' ),
			array( 'fab fa-nfc-directional' => 'nfc directional' ),
			array( 'fab fa-meta' => 'meta' ),
			array( 'fab fa-hashnode' => 'hashnode' ),
			array( 'fab fa-golang' => 'golang' ),
			array( 'fab fa-bots' => 'bots' ),
			array( 'fab fa-bilibili' => 'bilibili' ),
		)
	);

	return array_merge( $icons, $novo );
}

function yprm_custom_icons($icons) {
  global $novo_theme;
  $array = json_decode('['.$novo_theme['icon_fonts'].']');
  $result_array = array();

  foreach($array as $item) {
    $classes = explode(',', $item->classes);

    $result_array[$item->font_family] = array();
    
    foreach($classes as $icon) {
      array_push($result_array[$item->font_family], array(
        $icon => ''
      ));
    }
  }
  
  return array_merge($icons, $result_array);
}

class YPRM_Enqueue_Icon_Font {

	public function __construct() {
  
	  global $novo_theme;
  
	  $array = [];
	  if ( isset ( $novo_theme[ 'icon_fonts' ] ) ) {
		$array = json_decode( '[' . $novo_theme[ 'icon_fonts' ] . ']' );
	  }
  
	  if ( count( $array ) > 0 ) {
  
		foreach ( $array as $item ) {
  
		  yprm_enqueue_icon_font( $item );
  
		}
  
	  }
  
	}
  }

new YPRM_Enqueue_Icon_Font();

function yprm_elementor_add_icons( $tabs = array() ) {

	// Append new icons
  $base_ui = $photo = $multimedia = $web_application = $web_design = $music = $brands_novo = [];

	foreach(novo_iconpicker()['Base UI (Novo Pack)'] as $icon) {
		$base_ui[] = str_replace('basic-ui-', '', key($icon));
	}
	foreach(novo_iconpicker()['Photo (Novo Pack)'] as $icon) {
		$photo[] = str_replace('photo-icon-', '', key($icon));
	}
	foreach(novo_iconpicker()['Multimedia (Novo Pack)'] as $icon) {
		$multimedia[] = str_replace('multimedia-icon-', '', key($icon));
	}
	foreach(novo_iconpicker()['Web Application (Novo Pack)'] as $icon) {
		$web_application[] = str_replace('web-application-icon-', '', key($icon));
	}
	foreach(novo_iconpicker()['Web Design (Novo Pack)'] as $icon) {
		$web_design[] = str_replace('web-design-icon-', '', key($icon));
	}
	foreach(novo_iconpicker()['Music & Multimedia (Novo Pack)'] as $icon) {
		$music[] = str_replace('music-and-multimedia-', '', key($icon));
	}
 	foreach(novo_iconpicker()['Brands (Novo Pack)'] as $icon) {
		$brands_novo[] = str_replace('fab fa-', '', key($icon));
	}   
	
	$tabs['brands'] = array(
		'name'          => 'brands',
		'label'         => esc_html__( 'Brands', 'novo' ),
		'labelIcon'     => 'fab fa-x-twitter',
		'prefix'        => 'fa-',
		'displayPrefix' => 'fab',
		'url'           => get_parent_theme_file_uri() . '/css/fontawesome.min.css',
		'icons'         => $brands_novo,
		'ver'           => '1.0.0',
		'native'        => true
	);
	$tabs['base_ui'] = array(
		'name'          => 'basic-ui',
		'label'         => esc_html__( 'Base UI', 'novo' ),
		'labelIcon'     => 'basic-ui-icon-cloud',
		'prefix'        => 'basic-ui-',
		'displayPrefix' => 'basic-ui',
		'url'           => get_parent_theme_file_uri() . '/css/iconfont.css',
		'icons'         => $base_ui,
		'ver'           => '1.0.0',
		'native'        => true
	);
	$tabs['photo'] = array(
		'name'          => 'photo',
		'label'         => esc_html__( 'Photo', 'novo' ),
		'labelIcon'     => 'photo-icon-photo-camera',
		'prefix'        => 'photo-icon-',
		'displayPrefix' => 'photo',
		'url'           => get_parent_theme_file_uri() . '/css/iconfont.css',
		'icons'         => $photo,
		'ver'           => '1.0.0',
		'native'        => true
	);
	$tabs['multimedia'] = array(
		'name'          => 'multimedia',
		'label'         => esc_html__( 'Multimedia', 'novo' ),
		'labelIcon'     => 'multimedia-icon-browser-1',
		'prefix'        => 'multimedia-icon-',
		'displayPrefix' => 'multimedia-icon',
		'url'           => get_parent_theme_file_uri() . '/css/iconfont.css',
		'icons'         => $multimedia,
		'ver'           => '1.0.0',
		'native'        => true
	);
	$tabs['web_application'] = array(
		'name'          => 'web_application',
		'label'         => esc_html__( 'Web Application', 'novo' ),
		'labelIcon'     => 'web-application-icon-blank-cube',
		'prefix'        => 'web-application-icon-',
		'displayPrefix' => 'web-application-icon',
		'url'           => get_parent_theme_file_uri() . '/css/iconfont.css',
		'icons'         => $web_application,
		'ver'           => '1.0.0',
		'native'        => true
	);
	$tabs['web_design'] = array(
		'name'          => 'web_design',
		'label'         => esc_html__( 'Web Design', 'novo' ),
		'labelIcon'     => 'web-design-icon-browser-7',
		'prefix'        => 'web-design-icon-',
		'displayPrefix' => 'web-design-icon',
		'url'           => get_parent_theme_file_uri() . '/css/iconfont.css',
		'icons'         => $web_design,
		'ver'           => '1.0.0',
		'native'        => true
	);
	$tabs['music'] = array(
		'name'          => 'music',
		'label'         => esc_html__( 'Music Multimedia', 'novo' ),
		'labelIcon'     => 'music-and-multimedia-cd',
		'prefix'        => 'music-and-multimedia-',
		'displayPrefix' => 'music-and-multimedia',
		'url'           => get_parent_theme_file_uri() . '/css/iconfont.css',
		'icons'         => $music,
		'ver'           => '1.0.0',
		'native'        => true
	);

	return $tabs;
}

add_filter( 'elementor/icons_manager/native', 'yprm_elementor_add_icons' );